/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.xml;

import cz.insophy.inplan.xml.ConversionException;
import cz.insophy.inplan.xml.SuperplanConverter;
import cz.insophy.inplan.xml.XmlSource;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuperplanConverterChain
implements SuperplanConverter {
    private static final Logger log = LoggerFactory.getLogger(SuperplanConverterChain.class);
    private final List<SuperplanConverter> converters;

    public SuperplanConverterChain(List<SuperplanConverter> converters) {
        this.converters = converters;
    }

    @Override
    public XmlSource convert(XmlSource source) throws ConversionException {
        XmlSource dest = source;
        for (SuperplanConverter converter : this.converters) {
            log.info("Converting superplan from " + converter.getFromVersion() + " to " + converter.getToVersion());
            dest = converter.convert(dest);
        }
        return dest;
    }

    @Override
    public int getFromVersion() {
        return this.converters.get(0).getFromVersion();
    }

    @Override
    public int getToVersion() {
        return this.converters.get(this.converters.size() - 1).getToVersion();
    }
}

